#!/bin/sh
set -x
echo "[ENTRYPOINT] STARTED"

SOCKET_PATH="/run/docker/plugins/kasmlogger.sock"
[ -e "$SOCKET_PATH" ] && rm "$SOCKET_PATH"

echo "[ENTRYPOINT] Launching plugin.py..."
python3 /plugin.py &

sleep 5
echo "[ENTRYPOINT] Checking socket existence..."
ls -l /run/docker/plugins

if [ ! -S "$SOCKET_PATH" ]; then
    echo "[ERROR] Socket not created: $SOCKET_PATH"
    exit 1
fi

tail -f /dev/null  # keep container alive
